DROP PROCEDURE [hips].[ClinicalDocumentGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 7 March 2012
-- Description:   Gets a specified record from the ClinicalDocument Table
-- 08/10/2012 - gmassey - changed Pcehr table to ClinicalDocument
-- 06/12/2012 - sbiber - Added status and removal information
-- 16/06/2013 - sbiber - Changed set ID length from 50 to 128
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentGet] 
(
	   @EpisodeId INT = null
	  ,@SourceSystemSetId Varchar(128) = null
	  ,@DocumentTypeId int = null
) AS
BEGIN
SELECT cd.ClinicalDocumentId,
		cd.SourceSystemSetId,
		cd.EpisodeId,
		cd.DocumentTypeId,
		dt.Description as DocumentTypeDescription,
		dt.Code as DocumentTypeCode,
		cd.RemovalReasonId,
		rr.Description as RemovalReasonDescription,
		cd.RemovedDate,
		cd.ClinicalDocumentStatusId,
		cd.DateCreated,
		cd.UserCreated,
		cd.DateModified,
		cd.UserModified
FROM  hips.ClinicalDocument As cd
INNER JOIN hips.DocumentType As dt on dt.DocumentTypeId = cd.DocumentTypeId
INNER JOIN hips.RemovalReason AS rr ON cd.RemovalReasonId = rr.RemovalReasonId
WHERE (EpisodeId = @EpisodeId OR @EpisodeId IS NULL)
AND (SourceSystemSetId = @SourceSystemSetId OR @SourceSystemSetId IS NULL)
AND (cd.DocumentTypeId = @DocumentTypeId OR @DocumentTypeId IS NULL)

END
GO

